#include <stdio.h>
#include <io.h>
#include <stdlib.h>
#include <dir.h>
#include <string.h>

int main (int argc, char *argv[], char *env[])
{
int a,b;
int j,i;
int n;
bool error;
char filename[MAXPATH];
char drive[MAXDRIVE];
char dir[MAXPATH];
char name[MAXPATH];
char name2[MAXFILE];
char ext[MAXEXT];
char buffer[1025];
char message[MAXPATH+128];

printf ("SPLITDSK v1.0, splits .dsk-images into parts of 720 kb\n");
printf ("(c)1997 Meusesoft\n\n");

error=false;

if (argc<=1)
	{
   printf("Usage: SPLITDSK source.dsk\n\n");
   return 0;
   }

strcpy(filename, argv[1]);
fnsplit (filename, drive, dir, name2, ext);
strcpy (name,drive);
strcat (name,dir);
strcat (name,name2);

strcpy(message,"Splitting ");
strcat(message,name2);
strcat(message,ext);
strcat(message,"\n\n");
printf(message);

if ((a=_rtl_open(filename,0))==-1)
	{
   strcpy(message, "Can't open or find ");
   strcat(message, filename);
   strcat(message, ".\n");
   printf(message);
   return 0;
   }
j=0;
while ((j<10) && (!error))
	{
   j++;

   strcpy(filename,name2);
   strcat(filename,".");
   itoa(j, ext, 10);
   strcat(filename,ext);

   if ((b=_rtl_creat(filename,0))==-1)
   	{
      strcpy(message, "Couldn't create file ");
      strcat(message, filename);
      strcat(message, ".\n");
      printf(message);
      return 0;
      }

   i=0;
   error=false;
   while ((i<720) && (!error))
   	{
      n=_rtl_read(a, &buffer, 1024);

      if (n==0)
      	{
         error=true;
         if (i!=0)
         	{
            printf("Unexpected end of sourcefile...\n");
            }
         }
      if (!error)
      	{
         if (_rtl_write(b, &buffer, 1024)==-1)
      		{
         	error=true;
         	printf("Couldn't write to file...\n");
         	}
         }
      i++;
   	}
   if (!error)
   	{
      strcpy(message, "disk ");
      strcat(message, ext);
      strcat(message, " extracted\n");
      printf(message);
   	}
	_rtl_close(b);
   if (eof(a)) error=true;
	}
_rtl_close(a);
return 0;
}

