/* COPIA720.EXE */
/* Para guardar discos de 1DD y 2DD en ficheros */
/* F. J. Martos - 12/8/95 */


#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <mem.h>


typedef unsigned char byte;


int  EstableceUnidad(char Cadena[]);
int  EstableceParametros(void);
void RecuperaParametros(void);
int  LeePista(byte Cilindro,byte Cabezal,byte Buffer[][0x200]);
int  LeeSectores(byte Cilindro,byte Cabezal,byte Sector,byte Cantidad,void *Buffer);
int  GrabaPista(byte Cilindro,byte Cabezal,void *Buffer);
int  FormateaPista(byte Cilindro,byte Cabezal);


static char LeerConErrores = 0;

int main(int argc,char *argv[]) {
 enum {GUARDAR_DISCO,GRABAR_DISCO} Operacion;
 char SimpleCara = 0,Formatear = 0,Verificar = 0,i,j;
 byte DatosPista[9][0x200];
 char *Mensaje;
 FILE *IdFich;

 if (argc == 1) {
  Mensaje = "\nEste programa sirve para guardar disquetes de 3 de baja densidad en ficheros,\npermitiendo su almacenamiento en disco duro o CD-ROM. Igualmente, puede grabar\nluego esos ficheros de nuevo sobre disquete.\n\n  COPIA720 origen destino [/1][/F][/V]\n\nDe los argumentos origen y destino, uno debe ser una unidad de disquetes de 3\ny el otro un especificador de fichero. La opcin /1 es til para el formato de\nsimple cara, y las otras dos activan el formateo y la verificacin al grabar.";
  goto Salida;
 }

 if (argc == 2) {
  Mensaje = "Falta un argumento";
  goto Salida_1;
 }

 for (i=3;i<argc;i++) {
  do {
   if (argv[i][0] == *"/") {
    if (argv[i][1] == *"1") {
     SimpleCara = 1;
     argv[i]+= 2;
     continue;
    }
    if ((argv[i][1] & 0xDF) == *"F") {
     Formatear = 1;
     argv[i]+= 2;
     continue;
    }
    if ((argv[i][1] & 0xDF) == *"V") {
     Verificar = 1;
     argv[i]+= 2;
     continue;
    }
    if (argv[i][1] == *"!") {
     LeerConErrores = 1;
     argv[i]+= 2;
     continue;
    }
   }
   Mensaje = "Opcin incorrecta";
   goto Salida_1;
  } while (argv[i][0]);
 }

 if (EstableceUnidad(argv[1])) {
  Operacion = GUARDAR_DISCO;
  IdFich = fopen(argv[2],"wb");
 }
 else {
  if (EstableceUnidad(argv[2])) {
   Operacion = GRABAR_DISCO;
   IdFich = fopen(argv[1],"rb");
  }
  else {
   Mensaje = "La unidad de disquetes no es correcta";
   goto Salida_1;
  }
 }
 if (!IdFich) {
  Mensaje = "No es posible abrir ese fichero";
  goto Salida_1;
 }

 if (!EstableceParametros()) {
  Mensaje = "No hay disquete en la unidad";
  goto Salida_2;
 }

 switch (Operacion) {

 case GUARDAR_DISCO:
  for (i=79;i;i--) cputs("");
  for (i=0;i<80;i++) {
   for (j=0;j<2;j++) {
    if (SimpleCara && j) setmem(DatosPista,sizeof DatosPista,0xE5);
    else
     if (!LeePista(i,j,DatosPista)) {
      Mensaje = "Error leyendo el disquete";
      goto Salida_3;
     }
    if (!fwrite(DatosPista,sizeof DatosPista,1,IdFich)) {
     Mensaje = "Error escribiendo el fichero";
     goto Salida_3;
    }
   }
   cputs("\b");
   clreol();
  }
  break;

 case GRABAR_DISCO:
  for (i=79;i;i--) cputs("");
  for (i=0;i<80;i++) {
   for (j=0;j<2;j++) {
    if (!fread(DatosPista,sizeof DatosPista,1,IdFich)) {
     Mensaje = "Error leyendo el fichero";
     goto Salida_3;
    }
    if (SimpleCara && j) continue;
Reintento:
    if (Formatear)
     if (!FormateaPista(i,j)) {
      Mensaje = "Error formateando el disquete";
      goto Salida_3;
     }
    if (!GrabaPista(i,j,DatosPista)) {
     Mensaje = "Error escribiendo el disquete";
     goto Salida_3;
    }
    if (Verificar) {
     byte DatosPistaBis[9][0x200];

     if (!LeePista(i,j,DatosPistaBis)) {
      Mensaje = "Error leyendo el disquete";
      goto Salida_3;
     }
     if (memcmp(DatosPista,DatosPistaBis,sizeof DatosPista)) {
      Mensaje = "Error en la verificacin";
      goto Salida_3;
     }
    }
   }
   cputs("\b");
   clreol();
  }

 }

 RecuperaParametros();
 fclose(IdFich);
 Mensaje = "Completado sin problemas";
Salida:
 puts(Mensaje);
 return 0;

Salida_3:
 if (Operacion == GRABAR_DISCO && !Formatear) {
  Formatear = 1;
  goto Reintento;
 }
 cputs("\r");
 clreol();
 RecuperaParametros();
Salida_2:
 fclose(IdFich);
 if (Operacion == GUARDAR_DISCO) remove(argv[2]);
Salida_1:
 puts(Mensaje);
 return 1;
}


static byte Unidad;

int EstableceUnidad(char Cadena[]) {
 if (Cadena[1]!=*":" || Cadena[2]) return 0;
 Unidad = (Cadena[0]&0xDF) - *"A";
 _AH = 0x08;
 _DL = Unidad;
 geninterrupt(0x13);
 if (_AH) return 0;
 return _BL==3 || _BL==4;
}


#define VectorInterrupcion(Numero) *(void far * far *)MK_FP(0,(Numero)<<2)

static void far *TablaParametrosEstandar;

int EstableceParametros(void) {
 TablaParametrosEstandar = VectorInterrupcion(0x1e);
 _AH = 0x18;
 _CH = 79;
 _CL = 9;
 _DL = Unidad;
 geninterrupt(0x13);
 if (_AH) return 0;
 _DX = _ES;
 VectorInterrupcion(0x1e) = MK_FP(_DX,_DI);     /* El cdigo de esta asignacin utiliza _ES */
 return 1;
}

void RecuperaParametros(void) {
 VectorInterrupcion(0x1e) = TablaParametrosEstandar;
}


int LeePista(byte Cilindro,byte Cabezal,byte Buffer[][0x200]) {
 char i,j;

 if (LeeSectores(Cilindro,Cabezal,1,9,Buffer)) return 1;
 for (i=1;i<=9;i++) {
  for (j=5;j;j--) if (LeeSectores(Cilindro,Cabezal,i,1,Buffer[i-1])) break;
  if (!j) {
   if (LeerConErrores) cputs("\a");
   else return 0;
  }
 }
 return 1;
}


int LeeSectores(byte Cilindro,byte Cabezal,byte Sector,byte Cantidad,void *Buffer) {
 char i;

 for (i=2;i;i--) {
  _AH = 0x02;
  _AL = Cantidad;
  _CH = Cilindro;
  _CL = Sector;
  _DH = Cabezal;
  _DL = Unidad;
  _ES = FP_SEG(Buffer);
  _BX = FP_OFF(Buffer);
  geninterrupt(0x13);
  if (!_AH) return 1;
  if (i & 1) continue;
  _AH = 0x00;
  _DL = Unidad;
  geninterrupt(0x13);
 }
 return 0;
}


int GrabaPista(byte Cilindro,byte Cabezal,void *Buffer) {
 char i;

 for (i=2;i;i--) {
  _AH = 0x03;
  _AL = 9;
  _CH = Cilindro;
  _CL = 1;
  _DH = Cabezal;
  _DL = Unidad;
  _ES = FP_SEG(Buffer);
  _BX = FP_OFF(Buffer);
  geninterrupt(0x13);
  if (!_AH) return 1;
  if (i & 1) continue;
  _AH = 0x00;
  _DL = Unidad;
  geninterrupt(0x13);
 }
 return 0;
}


int FormateaPista(byte Cilindro,byte Cabezal) {
 byte DatosMarcasDireccion[9][4];
 char SectorSliding,i;

 SectorSliding = (Cilindro%3)*3+Cabezal;
 for (i=1;i<=9;i++) {
  DatosMarcasDireccion[i-1][0] = Cilindro;
  DatosMarcasDireccion[i-1][1] = Cabezal;
  DatosMarcasDireccion[i-1][2] = i-SectorSliding+(i<=SectorSliding? 9:0);
  DatosMarcasDireccion[i-1][3] = 2;
 }
 for (i=2;i;i--) {
  _AH = 0x05;
  _CH = Cilindro;
  _DH = Cabezal;
  _DL = Unidad;
  _ES = FP_SEG(DatosMarcasDireccion);
  _BX = FP_OFF(DatosMarcasDireccion);
  geninterrupt(0x13);
  if (!_AH) return 1;
  if (i & 1) continue;
  _AH = 0x00;
  _DL = Unidad;
  geninterrupt(0x13);
 }
 return 0;
}


