
/*
 * xmodem.h
 *
 * written by Jun Mabuchi
 */

#ifndef	__XYMODEM_H
#define	__XYMODEM_H

/* status of displaying */
#define	SUCCESS		1
#define	RETRY		2

#endif
*/
#define	SUCCESS		1
#define	RETRY		2

/* control data */
#define	SOH	'\x01'		/* start of heading */
#define	STX	'\x02'		/* start of big packet */
#define	ACK	'\x06'		/* acknowledge */
#define	NAK	'\x15'		/* negative acknowledge */
#define	EOT	'\x04'		/* end of transfer */
#define	CAN	'\x18'		/* cancel */
#define	C	'\x43'		/* continue */

/* constants */
#define	XDATASIZE	128	/* data size of XMODEM */
#define	YDATASIZE	1024	/* data size of YMODEM */
#define	SUMPACKSIZE	132	/* size of packet (XMODEM check sum) */
#define	CRCPACKSIZE	133	/* size of packet (XMODEM CRC) */
#define	YPACKSIZE	1029	/* size of packet (YMODEM) */
#define	HANDTIME	60	/* wait time for hand shake (seconds) */
#define	WAITTIME	30	/* wait time for 1 packet (seconds) */
#define	MAXRETRY	20	/* maximum retry times */
#define	TIMEOUT		255

#endif
                                                                                                                           