
/*
 * type.c - display Shift-JIS files for mabTerm ver.2.xx
 *
 * Copyright (C) 1989-90 All Rights Reserved by Jun Mabuchi
 *
 * Compiled with LSI-C ver.2.10
 */

#pragma nonrec
#pragma optimize time

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "exparg.h"
#include "mtbios.h"
#include "mtbmacro.h"

typedef char	tiny, bool;

#define	_cgetc()		mtbios(___CGETC)
#define	exit(code)		EXIT(code)
#define	gputc(c)		CPUTC(c)
#define	gputcb(c)		CPUTC(c)
#define	gputs(s)		CPUTS(s)
#define	fopen(name, mode)	FOPEN(name, mode)
#define	fclose(fp)		FCLOSE(fp)
#define	fgetc(fp)		FGETC(fp)
#define	free(ptr)		mtbios(__FREE, ptr)

#define	MAXFILE	(256)
#define	isoption(c)	('-' == (c) || '/' == (c))
#define	ESC	0x1b
#define	CTRL_C	0x03


bool	b_flag = FALSE;		/* open file in binary mode */
bool	h_flag = FALSE;		/* undisplay filename */
bool	m_flag = FALSE;		/* more */

int	tabs = 8;		/* tabstop */

char	msgBuf[80] = {};
char	*progname = "";


#pragma optimize time
char	*skipsp(char *s)
{
	char	c;

	while ((c = *s) == '\t' || c == ' ' || c == '\n')
		++s;
	return (s);
}

/*
 * skip digit character
 */
#pragma optimize space
char	*skipdigit(char *s)
{
	char	c;

	while (c = *s, isdigit(c))
		++s;
	return (s);
}


/*
 * ascii to tiny
 */
#pragma optimize space
tiny	atot(char *s)
{
	tiny	val;
	char	c;

	s = skipsp(s);
	val = 0;
	while ((c = *s++), isdigit(c)) {
		val = (val * (tiny)10) + (c - '0');
	}
	return (val);
}

#pragma optimize space
char	*ctoa(char buf[], char l)
{
	extern unsigned int	strlen(char *);
	char	*bufp;
	char	one;
	char	i, j;
	char	ch;

	bufp = buf;
	do {
		one = l % 10;
		*bufp++ = one + '0';
		*bufp = '\0';
		l /= 10;
	} while (l != 0);

	/* reverse it */
	for (i = 0, j = strlen(buf) - 1; i < j; ++i, --j) {
		ch = buf[i];
		buf[i] = buf[j];
		buf[j] = ch;
	}

	return (buf);
}



#pragma optimize space
void	esckey(void)
{
	gputs("\n@drbL[Ă@");
	while (ESC != _cgetc())
		;
	gputc('\n');
}

#pragma optimize space
void	abort(void)
{
	esckey();
	exit(1);
}

/*
 * internal cgetc
 */
#pragma optimize space
int	cgetc(void)
{
	int	c;

	if ((c = _cgetc()) == CTRL_C)
		abort();
	else
		return (c);
}

#pragma optimize space
void	anykey(void)
{
	gputs("\r@L[Ă@");
	while (EOF == cgetc())
		;
}

/*
 * 	type 1 file
 */
#pragma optimize time
void	jtype(char *fname)
{
	FILE	*fp;
	int	fc, cc;
	char	*openmode;
	int	column;
	int	line;

	openmode = b_flag ? "rb" : "r";
	if (NULL == (fp = (FILE *)fopen(fname, openmode))) {
		gputs("\n\"");
		gputs(fname);
		gputs("\" I[vł܂");
		return;
	}
	if (!h_flag) {
		strcpy(msgBuf, "\r\n\"");
		strcat(msgBuf, fname);
		strcat(msgBuf, "\"\n");
		gputs(msgBuf);
	}
	column = line = 0;
	while (EOF != (fc = fgetc(fp))) {
 /* stop by any key and restart by any key */
		if ((cc = _cgetc()) != EOF) {
			if (cc == CTRL_C) {
				abort();
			} else if (cc == ESC) {
				gputs(\
			"\r\n@̃t@C\܂@\n");
				break;
			}
			while ((cc = _cgetc()) == EOF)
				;
			if (cc == CTRL_C) {
				abort();
			}
		}

		if (b_flag) {	/* binary */
			if ((char)fc == '\t') {
				do {
					gputcb(' ');
					++column;
				} while (0 != (column % tabs));
			} else if ((char)fc == '\r') {
				gputcb(fc);
				column = 0;
			} else {
				gputcb(fc);
				if ((char)fc == '\n')
					++line;
				++column;
			}
		} else {		/* ascii mode */
			if ((char)fc == '\t') {
				do {
					gputcb(' ');
					++column;
				} while (0 != (column % tabs));
			}
			else if ((char)fc == '\n') {
				gputcb('\r');
				gputcb('\n');
				++line;
				column = 0;
			}
			else {
				gputcb(fc);
				++column;
			}
		}
		if (column >= 80) {
			++line;
			column = 0;
		}
		if (line >= 22) {
			line = 0;
			if (m_flag) {	/* more */
				if (column != 0) {
					column = 0;
				}
				anykey();
				gputs("\r\x1b[K");
			}
		}
	}
	fclose(fp);
}

/*
 * usage in japanese
 */
#pragma optimize space
void	jusage(void)
{
	CPUTS(progname);
	CPUTS(" [{-|/}bhmt<num>] <filename> ...\n");
}


#pragma optimize space
void	opt(char *argp)
{
	while (*++argp) {
		switch (*argp) {
		case 'b':	/* binary mode */
			b_flag = TRUE;
			break;
		case 'h':	/* undisplay filename*/
			h_flag = TRUE;
			break;
		case 'm':	/* more */
			m_flag = TRUE;
			break;
		case 't':	/* tabstops */
			tabs = atot(++argp);
			while (isdigit(*argp))
				++argp;
			--argp;
			break;
		default:
			jusage();
			abort();
		}
	}
}

#pragma optimize space
void	main(int argc, char **argv)
{
	static char	*fnames[MAXFILE];
	int	nfiles, nopts;
	int	i, j;

	progname = argv[0];

/* option switches */
	for (i = 1, nopts = 0; i < argc; ++i) {
		if (isoption(*argv[i])) {
			++nopts;
			opt(argv[i]);
		}
	}

/* display files */
	if (argc - (nopts + 1) == 0) {	/* filespec is Not specified */
		jusage();
	}
	else {
		for (i = 1 + nopts; i < argc; ++i) {
			if (!isoption(*argv[i])) {
				nfiles = exparg(argv[i], MAXFILE, fnames);
				for (j = 0; j < nfiles; ++j) {
					if (j != 0 && m_flag) {	/* more */
						gputc('\n');
						anykey();
					}
					jtype(fnames[j]);
					free(fnames[j]);
				}
			}
		}
	}
	esckey();
}
                                                