/*
 * lib.c - library for xmodem
 *
 * written by Jun Mabuchi
 */
#pragma nonrec
#pragma optimize time

#include <stdefs.h>
#include "mtbios.h"
#include "mtbmacro.h"
#include "rsprm.h"


#define	TIMER	0xfc9e	/* pointer to timer incremented by 1/60 seconds */
#pragma optimize time
void	sleep(unsigned int times)
{
	*(unsigned int *)TIMER = 0;
	while (*(unsigned int *)TIMER < times)
	/*	if (CGETC() == '\x03')
			return*/;
}


typedef struct {
	char	hour;
	char	minute;
	char	second;
	char	secPar100;
} TIME;

void	getTime(TIME *);

#pragma optimize time
long	time(long *lp)
{
	auto TIME	now;

	getTime(&now);
	return (*lp = 
			(long)now.hour * (long)3600 
			+ (long)now.minute * (long)60 
			+ (long)now.second);
}

/*
 * long to ascii
 * unsigned only
 */
#pragma optimize space
char	*ltoa(char buf[], long l)
{
	extern unsigned int	strlen(char *);
	char	*bufp;
	char	one;
	char	i, j;
	char	ch;

	bufp = buf;
	do {
		one = l % 10;
		*bufp++ = one + '0';
		*bufp = '\0';
		l /= 10;
	} while (l != 0);

	/* reverse it */
	for (i = 0, j = strlen(buf) - 1; i < j; ++i, --j) {
		ch = buf[i];
		buf[i] = buf[j];
		buf[j] = ch;
	}

	return (buf);
}

static	RSPRM	rsp_bak;

/*
 *	set, reset environment for x/ymodem
 */
#pragma optimize space
void	rsatt(void)
{
	RSPRM	*rsprm;

	rsprm = (RSPRM *)mtbios(__RSPRM);
/*	rsp_bak = *rsprm;
	rsprm->charlen = '8';
	rsprm->sendlf = 'N';
	rsprm->recvlf = 'N';
	rsprm->xflow = 'N';
	rsprm->siso = 'N';
	rsprm->mask = 0xff;	*/
	rsprm->rawmode = TRUE;
/*	mtbios(__RSREINIT);	*/	/* It's problem! */
}

#pragma optimize space
void	rsdet(void)
{
	RSPRM	*rsprm;

	rsprm = (RSPRM *)mtbios(__RSPRM);
/*	*rsprm = rsp_bak;	*/
	rsprm->rawmode = FALSE;
/*	mtbios(__RSREINIT);	*/	/* It's problem! */
}

#ifdef	_NOT_COMMENT_OUT_
/*
 * fwrite for x/ymodem
 */
#pragma optimize time
void	_fwrite(char *buf, unsigned int count, FILE *fp)
{
	while (count--) {
		if (EOF == FPUTC(*buf++, fp)) {
			CPUTS("\n..Disk full!\007\n");
			myabort();
		}
	}
}

/*
 * fread for x/ymodem
 */
#pragma optimize time
void	_fread(char *buf, unsigned int count, FILE *fp)
{
	unsigned int	i;
	int		c;

	for (i = 0; i < count; ++i) {
		if (EOF == (c = FGETC(fp)))
			break;
		*buf++ = c;
	}
	return (i);
}

#endif
                                                                          