
/*
 * jstr.c 
 *
 *	Written by mab
 */

extern char	tolower(char), toupper(char);
#define	iskanji(c)	('\x81'<=(c)&&(c)<='\x9f' || '\xe0'<=(c)&&(c)<='\xfc')
#define	iskanji2(c)	('\x40'<=(c)&&(c)<='\x7e' || '\x80'<=(c)&&(c)<='\xfc')

/*
 * make characters in the string lower case
 * If characters are MS-KANJI, not touches it.
 */
char	*jstrlwr(char *s)
{
	char	*head;

	head = s;
	while (*s) {
		if (iskanji(*s))
			++s;	/* skip 2 bytes */
		else
			*s = tolower(*s);
		++s;
	}
	return (head);
}

char	*jstrupr(char *s)
{
	char	*head;

	head = s;
	while (*s) {
		if (iskanji(*s))
			++s;	/* skip 2 bytes */
		else
			*s = toupper(*s);
		++s;
	}
	return (head);
}
                                                           