
/*
 * fkey.c - on/off or set function keys for mabTerm ver.2.xx
 *
 * written by mab
 */

#pragma nonrec
#pragma optimize time

#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "mtbios.h"
#include "mtbmacro.h"


#define	FK_OFF	"\x1b[>1h"
#define	FK_ON	"\x1b[>1l"
#define	FKLEN	16
#define	FNKSTR	0xf87f

char	*progname = "";

void	usage(void)
{
	CPUTS(progname);
	CPUTS(" [{on|off}] [<keynumber>,<keystring>] ...\n");
}

void	setfk(int num, char *s)
{
	char	*chp;

	if (--num < 0 || num > 9) {
		usage();
		EXIT(1);
	}
	chp = (char *)(FNKSTR + FKLEN * num);
	if ('\0' == *s) {	/* clear */
		memset(chp, '\0', FKLEN);
	}
	else {			/* copy */
		strncpy(chp, s, FKLEN);
	}
}

char	axtoc(char *s)
{
	char	c;
	char	val;
	char	i;

	val = 0;
	for (i = 0; c = toupper(*s++), i < 2 && isxdigit(c); ++i) {
		if (c >= '0' && c <= '9') {
			val = (val * 16) + (c - '0');
		}
		else if (c >= 'A' && c <= 'F') {
			val = (val * 16) + (c - 'A' + 10);
		}
	}
	return (val);
}

char	*getstr(char *s)
{
	static char	buf[128];
	char	*chp;
	char	i;

	chp = buf;
	while (*s) {
		switch (*s) {
		case '\\':	/* escape */
			++s;
			if (isxdigit(*s)) {
				*chp++ = axtoc(s);
				for (i = 0; i < 2 && isxdigit(*s); ++i)
					++s;
			}
			else {
				usage();
				EXIT(1);
			}
			break;

		default:
			*chp++ = *s++;
			break;
		}
	}
	*chp = '\0';
	return (buf);
}

void	main(int argc, char **argv)
{
	char		*argp;
	int		i, keynum;

	progname = argv[0];

	if (argc < 2) {
		usage();
		EXIT(1);
	}

	argp = argv[1];
	if (0 == strcmp(argp, "on") || 0 == strcmp(argp, "off")) {
/* on/off */
		if (0 == strcmp(argp, "on")) {
			CPUTS(FK_ON);
		}
		else {
			CPUTS(FK_OFF);
		}
	}
	else {
/* set */
		for (i = 1; i < argc; ++i) {
			argp = argv[i];
			if (isdigit(*argp)) {
				keynum = atoi(argp);
				while (isdigit(*argp))
					++argp;
				if (*argp != ',') {
					usage();
					EXIT(1);
				}
				else {
					setfk(keynum, getstr(++argp));
				}
			}
			else {
				usage();
				EXIT(1);
			}
		}
		CPUTS(FK_OFF);
		CPUTS(FK_ON);
	}

	EXIT(0);
}
                                                                                                                        