
/*
 *	expand wildcard with searching directory
 */

#pragma nonrec
#pragma optimize time

#include	<stdio.h>
#include	<string.h>
#include	<bdosfunc.h>
#include	<stdlib.h>
#include	"mtbios.h"
#include	"mtbmacro.h"
#include	"exparg.h"

#define	sbrk(size)	(void *)mtbios(__MALLOC, (int)size)

/*
 *	compare
 */
static	int	_cmp(char **p, char **q)
{
	return (strcmp(*p, *q));
}

/*
 *	expand wildcard with searching directory
 *
 * If error occurred return ERROR, else return number of matched directory.
 */
int	exparg(char *pat, int maxargc, char *xargv[])
{
	extern int	_setupfcb(char *, FCB *);
	static FCB	fcb, dir;
	static char	fn[20];
	char	dc, c, *p;
	int	xargc;
	char	i;

	if (WILDCARD == _setupfcb(pat, &fcb)) {
		xargc = 0;
		bdos(SETDMA, &dir);
		for (dc = bdos(SEARF, &fcb); dc != BDOSERR; dc = bdos(SEARN)) {
			p = fn;
			if (fcb.dc != 0) {
				*p++ = fcb.dc + 'A' - 1;
				*p++ = ':';
			}
			for (i = 0; i < 8 && (c = dir.name[i]) != ' '; ++i)
				*p++ = c;
			*p++ = '.';
			for (i = 0; i < 3 && (c = dir.ext[i]) != ' '; ++i)
				*p++ = c;
			if (*(p - 1) == '.') /* remove last '.' in file name */
				--p;
			*p = '\0';
			if (xargc >= maxargc || 
					(p = sbrk(strlen(fn) + 1)) == ERROR)
				break;
			xargv[xargc++] = strcpy(p, fn);
		}
		if (dc != BDOSERR)
			return (ERROR);
		qsort(xargv, xargc, sizeof(char *), (int (*)())_cmp);
		return (xargc);
	}
	else {
		if (maxargc < 1 || (p = sbrk(strlen(pat) + 1)) == ERROR)
			return (ERROR);
		xargv[0] = p;
		while (*p++ = *pat++)
			;
		return (1);
	}
}
pat[0] != '\0' && pat[1] == ':') {
			if ((c = toupper(pat[0]) - 'A' + 1) > MAXDRIVE)
				return (ERROR);
			sf.dc = c;
		} else
			sf.dc = '\0';
		xargc = 0;
		bdos(SETDMA, dir);
		for (dc = bdos(SEARF, &sf); dc != BDOSERR; dc = bdos(SEARN)) {
			p = fn;
			if (sf.dc != 0) {
				*p++ = sf.dc + 'A' - 1;
				*p++ = ':';
			}
			for (i = 0; i < 8 && (c = dir[dc].name[i]) != ' '; i++)
				*p++ = c;
			*p++ = '.';
			for (i = 0; i < 3 && (c = dir[dc].type[i]) != ' '; i++)
				*p++ = c;
			*p++ = '\0';
			if (_amatch(pat, fn)) {
				if (xargc >= maxargc ||
						(p = sbrk(p - fn)) == ERROR)
					break;
				xargv[xargc++] = strcpy(p, fn);
			}
		}
		if (dc != BDOSERR)
			return (ERROR);
		qsort(xargv, xargc, sizeof(char *), _cmp);
		if (xargc != 0)
			return (xargc);
	}
	/* otherwise (no wildcard or no match) */
	if (maxargc < 1 || (p = sbrk(strlen(pat) + 1)) == ERROR)
		return (ERROR);
	xargv[0] = p;
	while (*p++ = *pat++ & 0x7F)
		;
	return (1);
}

****************************************************/

/*
 *	compare
 */
static	int	_cmp(char **p, char **q)
{
	return (strcmp(*p, *q));
}


/*
 *	expand wildcard with searching directory
 *
 * If error occurred return ERROR, else return number of matched directory.
 */
int	exparg(char *pat, int maxargc, char *xargv[])
{
	extern int	_setupfcb(char *, FCB *);
	static FCB	fcb, dir;
	static char	fn[20];
	char	dc, c, *p;
	int	xargc;
	char	i;

	if (WILDCARD == _setupfcb(pat, &fcb)) {
		xargc = 0;
		bdos(SETDMA, &dir);
		for (dc = bdos(SEARF, &fcb); dc != BDOSERR; dc = bdos(SEARN)) {
			p = fn;
			if (fcb.dc != 0) {
				*p++ = fcb.dc + 'A' - 1;
				*p++ = ':';
			}
			for (i = 0; i < 8 && (c = dir.name[i]) != ' '; ++i)
				*p++ = c;
			*p++ = '.';
			for (i = 0; i < 3 && (c = dir.ext[i]) != ' '; ++i)
				*p++ = c;
			if (*(p - 1) == '.') /* remove last '.' in file name */
				--p;
			*p = '\0';
			if (xargc >= maxargc || 
					(p = sbrk(strlen(fn) + 1)) == ERROR)
				break;
			xargv[xargc++] = strcpy(p, fn);
		}
		if (dc != BDOSERR)
			return (ERROR);
		qsort(xargv, xargc, sizeof(char *), (int (*)())_cmp);
		return (xargc);
	}
	else {
		if (maxargc < 1 || (p = sbrk(strlen(pat) + 1)) == ERROR)
			return (ERROR);
		xargv[0] = p;
		while (*p++ = *pat++)
			;
		return (1);
	}
}

/*********************

/*
 *	from msx-c standard library
 */
int     expargs(argc, argv, maxargc, xargv)
int     argc, maxargc;
char    *argv[], *xargv[];
{
    auto struct {
	    char    dc, name[8], type[3], filler[21];
    }       dir;

    FCB     sf;
    int     xargc, topc, i;
    char    rc, c, *p, **topv, fn[20];

    xargc = 0;
    while (--argc >= 0) {
	p = *argv++;
	if (_setupfcb(p, &sf) == WILDCARD) {
	    topv = xargv;   topc = xargc;
	    bdos(SETDMA, &dir);
	    for (rc=bdos(SEARF, &sf); rc!=BDOSERR; rc=bdos(SEARN)) {
		if (xargc >= maxargc)
		    return (ERROR);
		dir.dc = sf.dc;

		p = _filename(&dir, fn);

		if ((p = sbrk(p - fn)) == ERROR) {
		    return (ERROR);
		}
		strcpy(p, fn);
		*xargv++ = p;
		xargc++;
	    }
	    qsort(topv, xargc - topc, sizeof(char *), _cmp);
	}
	else {
	    if (xargc >= maxargc)
		return (ERROR);
	    *xargv++ = p;
	    xargc++;
	}
    }
    return (xargc);
}

*****************************/


****/



	    xargc++;
	}
    }
    return (xargc);
}

*****************************/


                                                       