
/*
 * disp.c
 */

#pragma nonrec
#pragma optimize time

#include "xmodem.h"
#include "mtbios.h"
#include "mtbmacro.h"

extern long	time(long *);
extern char	*ltoa(char *, long);

extern char		crcflg;
extern unsigned int	blockNo;

long	startTime;

void	dispinit(char *fname)
{
	CPRINTF("\r\"%s\" ", fname);
	CPRINTF("%s-", "XMODEM");
	CPRINTF("(%s)\n\x1b[K", crcflg ? "CRC" : "SUM");
	time(&startTime);
}

void	dispratio(int stat)
{
	switch (stat) {
	case SUCCESS:
		CPRINTF("\rBlock #%u Ok\x1b[K", blockNo);
		break;
	case RETRY:
		CPRINTF("\rBlock #%u Error\n", blockNo);
		break;
	}
}

void	dispdone(void)
{
	long	endTime;
	char	buf[20];

	time(&endTime);
	endTime -= startTime;
	if (endTime == 0)
		endTime = 1;
	CPRINTF("\rTransfer succeeded (%ssec)\x1b[K\n",ltoa(buf, endTime));
}
                                                         