
/*
 * dir.c - dir command for `mabTerm'
 *
 * 89-09-23	Written by Jun Mabuchi
 * 90-02-??	???
 * 90-05-15	simulate ^S ^Q
 *
 * Language : LSI-C ver.2.10
 */

#pragma nonrec
#pragma optimize space


#include	<bdosfunc.h>
#include	<string.h>
#include	"types.h"
#include	"bdoscall.h"
#include	"mtbios.h"
#include	"mtbmacro.h"

extern char	tolower(char), toupper(char);
extern int	sprintf(char *, char *, ...);

#define	EOF	(-1)


static void	setwild(char *ptr, FCB *fcbp)
{
	tiny	i;

	setmem(fcbp, sizeof(FCB), '\0');
	setmem(fcbp->name, 11, ' ');

	if (ptr[0] && ptr[1] == ':') {
		fcbp->dc = toupper(*ptr) - 'A' + 1;
		ptr += 2;
	}
	if (*ptr == '\0') {
		ptr = "*.*";
	}
	for (i = 0; i < 8; ++i) {
		switch (*ptr) {
		case '*':
			fcbp->name[i] = '?';
			break;
		case '\0':
		case '.':
			fcbp->name[i] = ' ';
			break;
		case '?':
		default:
			fcbp->name[i] = *ptr;
			++ptr;
		}
	}

	while (*ptr != '.' && *ptr != '\0')
		++ptr;		/* skip to '.' */
	if (*ptr == '.')
		++ptr;
	else if (*ptr == '\0')
		*ptr = '*';

	for (i = 8; i < 11; ++i) {
		switch (*ptr) {
		case '*' :
			fcbp->name[i] = '?';
			break;
		case '\0' :
			fcbp->name[i] = ' ';
			break;
		case '?' :
		default :
			fcbp->name[i] = *ptr;
			++ptr;
			break;
		}
	}
}

/*
static void	putName(FCB *fcbp)
{
	tiny	i, j;

	for (i = 0, j = 0; j < 8 && fcbp->name[j] != ' '; ++i, ++j)
		CPUTC((int)tolower(fcbp->name[j]));
	if (fcbp->ext[0] != ' ') {
		CPUTC((int)'.');
		++i;
	}
	for (j = 0; j < 3 && fcbp->ext[j] != ' '; ++i, ++j)
		CPUTC((int)tolower(fcbp->ext[j]));
	while (i < 16) {
		CPUTC((int)' ');
		++i;
	}
}
*/
static void	putName(FCB *fcbp)
{
	char	i, j;
	static char	buf[20];
	extern char	*jstrlwr(char *);

	j = 0;
	for (i = 0; i < 8 && fcbp->name[i] != ' '; ++i)
			buf[j++] = fcbp->name[i];
	if (fcbp->ext[0] != ' ')
		buf[j++] = '.';
	for (i = 0; i < 3 && fcbp->ext[i] != ' '; ++i)
			buf[j++] = fcbp->ext[i];
	buf[j] = '\0';
	CPRINTF("%-16s", jstrlwr(buf));
}

/*
typedef struct {
	uint	sectorSize;
	uint	maxClusters;
	uint	nonusedClusters;
	uint	dpbPtr;
	uint	fatPtr;
} DISKINFO;

tiny	diskInfo(DISKINFO *info, tiny drive);
*/

static void	searchDir(FCB *fcbp, FCB *dma)
{
	tiny	files;
	tiny	stat;
	auto DISKINFO	info;
	int		c;
	static char	strbuf[80];

	setmem(dma, sizeof(FCB), '\0');
	bdos((char)0x1a, (uint)dma);	/* set DMA address */

	files = 0;
	for (stat = bdos(SEARF, fcbp); stat != BDOSERR; stat = bdos(SEARN)) {
		putName(dma);
		++files;
		switch (CGETC()) {
		case EOF:
			break;
		case 0x03:	/* ^C */
		case 0x18:	/* ^X */
			EXIT(1);
		default:
			while (EOF == (c = CGETC()))
				;
			if (c == 0x03 || c == 0x18)
				EXIT(1);
			break;
		}
	}
	if (BDOSERR == (stat = diskInfo(&info, fcbp->dc))) {
		CPUTS("\nInvalid drive.\7\n");
	}
	else {
		if ((files % 5) != 0)
			CPUTC((int)'\n');
		/* calculate disk free */
/*
		GPRINTF("\r %d files  ", (int)files);
		GPRINTF("%ld Kbytes free\n", 
		( (long)info.nonusedClusters * (long)(info.sectorSize * stat) ));
*/
/*
		SPRINTF("\r %d files", files);
		SPRINTF("  %ld bytes free\n", (int)files,
		((long)info.nonusedClusters * (long)(info.sectorSize * stat)));
		CPUTS(strbuf);
*/
		sprintf(strbuf, "\r %d files  %ld bytes free\n",
		(int)files, 
		(long)info.nonusedClusters 
		* ((long)info.sectorSize * (long)stat));
		CPUTS(strbuf);
	}
}

void	main(int argc, char **argv)
{
	static FCB	ufcb, udma;
	int		i;
	static char	*av[128/2];
	int		ac;

/* copy arguments */
	ac = argc;
	for (i = 0; i < ac; ++i)
		av[i] = argv[i];

	if (ac < 2) {
		av[1] = "*.*";
		av[2] = NULL;
		ac = 2;
	}
	for (i = 1; i < ac; ++i) {
		setwild(av[i], &ufcb);
		searchDir(&ufcb, &udma);
	}
	EXIT(0);
}
;
	}
	EXIT(0);
}
for (i = 1; i < ac; ++i) {
		setwild(av[i], &ufcb);
		searchDir(&ufcb, &udma);
	}
	EXIT(0);
}
          