
/*
 * bdoscall.h
 *
 * Header file of BDOS calls
 * Copyright (C) 1988, 1989 by Jun Mabuchi
 * Written by Jun Mabuchi
 */

#ifndef	__BDOSCALL_H
#define	__BDOSCALL_H

#ifndef	__TYPES_H
#include "types.h"
#endif

typedef struct {
	tiny	hour;
	tiny	minute;
	tiny	second;
	tiny	secPar100;
} TIME;

void	getTime(TIME *);

typedef struct {
	uint	year;
	tiny	month;
	tiny	day;
	tiny	dayOfTheWeek;
} DATE;

void	getDate(DATE *);

typedef struct {
	uint	sectorSize;
	uint	maxClusters;
	uint	nonusedClusters;
	uint	dpbPtr;
	uint	fatPtr;
} DISKINFO;

tiny	diskInfo(DISKINFO *info, tiny drive);


        